<?php

declare(strict_types=1);

namespace Ferienpass\CoreBundle\Tests\Dto;

use Ferienpass\CoreBundle\Dto\Currency;
use PHPUnit\Framework\TestCase;

final class CurrencyTest extends TestCase
{
    public function testReturnsGivenAmountAndDefaultDivisor(): void
    {
        $c = new Currency(1234);

        $this->assertSame(1234, $c->getAmount());
        $this->assertSame(100, $c->getDivisor());
    }

    public function testCustomDivisorIsRespected(): void
    {
        $c = new Currency(5000, 1000);

        $this->assertSame(5000, $c->getAmount());
        $this->assertSame(1000, $c->getDivisor());
    }
}
