<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Validator;

use Symfony\Component\Validator\Constraint;

#[\Attribute]
class ValidFriendCode extends Constraint
{
    public string $messageEmpty = 'Bitte geben Sie einen Freunde-Code ein.';
    public string $messageInvalidOffer = 'Der Freunde-Code "{{ string }}" ist nicht für diese Veranstaltung gültig.';
    public string $messageNotFound = 'Der Freunde-Code "{{ string }}" ist ungültig.';

    public function __construct(?array $groups = null, $payload = null)
    {
        parent::__construct([], $groups, $payload);
    }

    public function validatedBy(): string
    {
        return FriendCodeValidator::class;
    }
}
