<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Validator;

use Symfony\Component\Validator\Constraint;

#[\Attribute]
class ValidAccessCode extends Constraint
{
    public string $message = 'The access code "{{ string }}" is not valid or was already used.';

    public function __construct(public bool $checkUsage = true, ?string $message = null, ?array $groups = null, $payload = null)
    {
        parent::__construct([], $groups, $payload);

        $this->message = $message ?? $this->message;
    }

    public function validatedBy(): string
    {
        return AccessCodeValidator::class;
    }
}
