<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Twig\Extension;

use Contao\CoreBundle\Filesystem\FilesystemItem;
use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Ferienpass\CoreBundle\Entity\DbafsLogo;
use Ferienpass\CoreBundle\Entity\DbafsMedia;
use Ferienpass\CoreBundle\Entity\OfferMedia;
use Symfony\Component\HttpFoundation\UriSigner;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Twig\Attribute\AsTwigFilter;
use Twig\Attribute\AsTwigFunction;

class FerienpassTwigExtension
{
    public function __construct(private readonly VirtualFilesystemInterface $logosStorage, private readonly VirtualFilesystemInterface $mediaStorage, private readonly UrlGeneratorInterface $urlGenerator, private readonly UriSigner $uriSigner)
    {
    }

    #[AsTwigFilter('to_filesystem_item')]
    public function toFilesystemItem(DbafsMedia|DbafsLogo|OfferMedia $entity): ?FilesystemItem
    {
        if ($entity instanceof DbafsLogo) {
            return $this->logosStorage->get($entity->getUuid());
        }

        if ($entity instanceof OfferMedia) {
            $entity = $entity->getMedia();
        }

        return $this->mediaStorage->get($entity->getUuid());
    }

    #[AsTwigFunction('signed_path')]
    public function generateSignedUrl(string $route, array $parameters = []): string
    {
        $url = $this->urlGenerator->generate($route, $parameters);

        return $this->uriSigner->sign($url);
    }
}
