<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Security\Voter;

use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\User;
use Symfony\Bundle\SecurityBundle\Security;
use Symfony\Component\Security\Core\Authentication\Token\TokenInterface;
use Symfony\Component\Security\Core\Authorization\Voter\Voter;

class AttendanceVoter extends Voter
{
    public function __construct(private readonly Security $security)
    {
    }

    protected function supports($attribute, $subject): bool
    {
        if ('withdraw' !== $attribute) {
            return false;
        }

        return $subject instanceof Attendance;
    }

    protected function voteOnAttribute($attribute, $subject, TokenInterface $token, ?\Symfony\Component\Security\Core\Authorization\Voter\Vote $vote = null): bool
    {
        $user = $token->getUser();
        if (!$user instanceof User) {
            return false;
        }

        /** @var Attendance $attendance */
        $attendance = $subject;

        if ('withdraw' === $attribute) {
            return $this->canWithdraw($attendance, $user);
        }

        throw new \LogicException('This code should not be reached!');
    }

    private function canWithdraw(Attendance $attendance, User $user): bool
    {
        if ($this->security->isGranted('ROLE_ADMIN')) {
            return true;
        }

        $participant = $attendance->getParticipant();
        if (!$participant instanceof \Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface) {
            return false;
        }

        if (!($member = $participant->getUser()) instanceof User) {
            return false;
        }

        return $member->getId() === $user->getId();
    }
}
