<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Security\UserChecker;

use Ferienpass\CoreBundle\Entity\User;
use Symfony\Component\Security\Core\Exception\CustomUserMessageAccountStatusException;
use Symfony\Component\Security\Core\User\UserCheckerInterface;
use Symfony\Component\Security\Core\User\UserInterface;

class FrontendUserChecker implements UserCheckerInterface
{
    public function checkPreAuth(UserInterface $user): void
    {
    }

    public function checkPostAuth(UserInterface $user): void
    {
        if (!$user instanceof User) {
            return;
        }

        $this->checkIfFrontendUser($user);
    }

    private function checkIfFrontendUser(User $user): void
    {
        if ($user->isMember()) {
            return;
        }

        $ex = new CustomUserMessageAccountStatusException('Wir können Sie hier nicht anmelden. Bitte probieren Sie das Anmeldeformular im Admin-Portal.');
        $ex->setUser($user);

        throw $ex;
    }
}
