<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Ferienpass\CoreBundle\Entity\User;
use Webauthn\Bundle\Repository\CanGenerateUserEntity;
use Webauthn\Bundle\Repository\CanRegisterUserEntity;
use Webauthn\Bundle\Repository\PublicKeyCredentialUserEntityRepositoryInterface;
use Webauthn\PublicKeyCredentialUserEntity;

class WebauthnUserEntityRepository implements PublicKeyCredentialUserEntityRepositoryInterface, CanRegisterUserEntity, CanGenerateUserEntity
{
    /**
     * The UserRepository $userRepository is the repository
     * that already exists in the application.
     */
    public function __construct(private readonly UserRepository $userRepository)
    {
    }

    public function findOneByUsername(string $username): ?PublicKeyCredentialUserEntity
    {
        /** @var User|null $user */
        $user = $this->userRepository->findOneBy([
            'username' => $username,
        ]);

        return $this->getUserEntity($user);
    }

    public function findOneByUserHandle(string $userHandle): ?PublicKeyCredentialUserEntity
    {
        /** @var User|null $user */
        $user = $this->userRepository->findOneBy([
            'id' => $userHandle,
        ]);

        return $this->getUserEntity($user);
    }

    public function saveUserEntity(PublicKeyCredentialUserEntity $userEntity): void
    {
        // TODO: Implement saveUserEntity() method.
    }

    public function generateUserEntity(?string $username, ?string $displayName): PublicKeyCredentialUserEntity
    {
        // TODO: Implement generateUserEntity() method.
    }

    /**
     * Converts a Symfony User (if any) into a Webauthn User Entity.
     */
    private function getUserEntity(?User $user): ?PublicKeyCredentialUserEntity
    {
        if (!$user instanceof User) {
            return null;
        }

        return new PublicKeyCredentialUserEntity(
            $user->getUsername(),
            \sprintf('user-%s', $user->getId()),
            $user->getName(),
            null
        );
    }
}
