<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Ferienpass\CoreBundle\Entity\User;
use Symfony\Component\Uid\Uuid;

interface ParticipantRepositoryInterface extends RepositoryInterface
{
    public function createNew(?User $user = null): ParticipantInterface;

    public function findByUuid(string|Uuid $uuid): ?ParticipantInterface;
}
