<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Ferienpass\CoreBundle\Entity\User;
use Symfony\Component\Uid\Uuid;

class ParticipantRepository extends EntityRepository implements ParticipantRepositoryInterface
{
    public function createNew(?User $user = null): ParticipantInterface
    {
        $className = $this->getClassName();

        return new $className($user);
    }

    public function findByUuid(string|Uuid $uuid): ?ParticipantInterface
    {
        return $this->findOneBy(['uuid' => $uuid]);
    }
}
