<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\ORM\QueryBuilder;
use Doctrine\Persistence\ManagerRegistry;
use Ferienpass\CoreBundle\Entity\Edition;
use Ferienpass\CoreBundle\Entity\Notification;

class NotificationRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Notification::class);
    }

    public function findOneByTypeAndEdition(string $key, ?Edition $edition = null, bool $strict = false): ?Notification
    {
        $query = $this->createQueryBuilder('n')
            ->where('n.type = :type')
            ->andWhere('n.disable = 0')
            ->setParameter('type', $key)
        ;

        $this->andWhereEdition($query, $edition, $strict);

        return $query->getQuery()->setMaxResults(1)->getOneOrNullResult();
    }

    private function andWhereEdition(QueryBuilder $query, ?Edition $edition, bool $strict): void
    {
        if (!$edition instanceof Edition && $strict) {
            $query->andWhere('n.edition IS NULL');

            return;
        }

        if ($strict) {
            $query
                ->andWhere('n.edition = :edition')
                ->setParameter('edition', $edition)
            ;

            return;
        }

        $query
            ->andWhere('n.edition = :edition OR n.edition IS NULL')
            ->addSelect('(CASE WHEN n.edition = :edition THEN 1 ELSE 0 END) AS HIDDEN mainSort')
            ->addOrderBy('mainSort', 'DESC')
            ->setParameter('edition', $edition)
        ;
    }
}
