<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ferienpass\CoreBundle\Entity\Consent;
use Ferienpass\CoreBundle\Entity\ConsentForm;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Ferienpass\CoreBundle\Entity\User;

class ConsentRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Consent::class);
    }

    /**
     * @param ConsentForm[]          $consentForms
     * @param ParticipantInterface[] $participants
     *
     * @return Consent[]
     */
    public function findSignatures(array $consentForms, ?User $user, array $participants): array
    {
        if (empty($consentForms)) {
            return [];
        }

        $qb = $this->createQueryBuilder('c')
            ->where('c.consentForm IN (:forms)')
            ->setParameter('forms', $consentForms)
        ;

        $orX = $qb->expr()->orX();

        if ($user) {
            $orX->add($qb->expr()->andX(
                $qb->expr()->eq('c.user', ':user'),
                $qb->expr()->isNull('c.participant')
            ));
            $qb->setParameter('user', $user);
        }

        if (!empty($participants)) {
            $orX->add($qb->expr()->in('c.participant', ':participants'));
            $qb->setParameter('participants', $participants);
        }

        if ($orX->count() > 0) {
            $qb->andWhere($orX);
        } else {
            return [];
        }

        return $qb->getQuery()->getResult();
    }

    /**
     * @return Consent[]
     */
    public function findAllForUser(User $user): array
    {
        return $this->createQueryBuilder('c')
            ->leftJoin('c.participant', 'p')
            ->where('c.user = :user')
            ->orWhere('p.user = :user')
            ->setParameter('user', $user)
            ->getQuery()
            ->getResult()
        ;
    }
}
