<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ferienpass\CoreBundle\Entity\ConsentForm;
use Ferienpass\CoreBundle\Entity\Edition;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Entity\User;

class ConsentFormRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, ConsentForm::class);
    }

    public function findByOfferOrEdition(OfferInterface $offer, Edition $edition, ?User $user = null, array $participants = []): array
    {
        $qb = $this->createQueryBuilder('f')
            ->distinct()
            ->addSelect('signature')
            ->where('f.edition = :edition')
            ->orWhere('f.offer = :offer')
            ->setParameter('edition', $edition)
            ->setParameter('offer', $offer)
        ;

        $orX = $qb->expr()->orX();
        if ($user) {
            $orX->add($qb->expr()->andX(
                $qb->expr()->eq('signature.user', ':user'),
                $qb->expr()->isNull('signature.participant')
            ));
            $qb->setParameter('user', $user);
        }

        if (!empty($participants)) {
            $orX->add($qb->expr()->in('signature.participant', ':participants'));
            $qb->setParameter('participants', $participants);
        }

        $qb->leftJoin('f.signatures', 'signature', 'WITH', $orX->count() > 0 ? $orX : '1 = 0');

        return $qb->getQuery()->getResult();
    }
}
