<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Repository;

use Doctrine\Bundle\DoctrineBundle\Repository\ServiceEntityRepository;
use Doctrine\Persistence\ManagerRegistry;
use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;

class AttendanceRepository extends ServiceEntityRepository
{
    public function __construct(ManagerRegistry $registry)
    {
        parent::__construct($registry, Attendance::class);
    }

    /**
     * @return Attendance[]
     */
    public function findConfirmed(int $offerId): array
    {
        return $this->createQueryBuilder('a')
            ->andWhere('a.offer = :offerId')
            ->andWhere('a.status = :status')
            ->setParameter('offerId', $offerId)
            ->setParameter('status', Attendance::STATUS_CONFIRMED)
            ->getQuery()
            ->getResult()
        ;
    }

    public function findExisting(OfferInterface $offer, ParticipantInterface $participant): ?Attendance
    {
        return $this->findOneBy(['offer' => $offer, 'participant' => $participant]);
    }
}
