<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\RemoteEvent;

use Ferienpass\CoreBundle\Message\FetchPmPaymentStatus;
use Ferienpass\CoreBundle\Webhook\PmPaymentNotifyEvent;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\RemoteEvent\Attribute\AsRemoteEventConsumer;
use Symfony\Component\RemoteEvent\Consumer\ConsumerInterface;
use Symfony\Component\RemoteEvent\RemoteEvent;

#[AsRemoteEventConsumer('pmPayment')]
final readonly class PmPaymentWebhookConsumer implements ConsumerInterface
{
    public function __construct(private MessageBusInterface $commandBus)
    {
    }

    public function consume(RemoteEvent $event): void
    {
        if (!($event instanceof PmPaymentNotifyEvent)) {
            return;
        }

        $this->handleEvent($event);
    }

    private function handleEvent(PmPaymentNotifyEvent $transaction): void
    {
        $this->commandBus->dispatch(new FetchPmPaymentStatus($transaction->getId()));
    }
}
