<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Payments\Provider;

use Ferienpass\CoreBundle\Entity\Payment;
use Symfony\Component\HttpFoundation\Request;

class NoOpPaymentProvider implements PaymentProviderInterface
{
    public function dispatchPayment(Payment $payment): string
    {
        throw new \BadMethodCallException('Please configure your app to bind the \Ferienpass\CoreBundle\Payments\Provider\PaymentProviderInterface correctly');
    }

    public function interpretRedirect(Request $request): int
    {
        throw new \BadMethodCallException('Please configure your app to bind the \Ferienpass\CoreBundle\Payments\Provider\PaymentProviderInterface correctly');
    }
}
