<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Notifier\Message;

use Contao\CoreBundle\Filesystem\FilesystemItem;
use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Symfony\Component\DependencyInjection\Attribute\Exclude;

#[Exclude]
readonly class Attachment
{
    public function __construct(private VirtualFilesystemInterface $filesystem, private FilesystemItem $filesystemItem)
    {
    }

    /**
     * @return resource
     */
    public function readStream()
    {
        return $this->filesystem->readStream($this->filesystemItem->getUuid());
    }

    public function getName(): ?string
    {
        return $this->filesystemItem->getName();
    }
}
