<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\NotificationHandler;

use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Message\RemindAttendance as RemindAttendanceEvent;
use Ferienpass\CoreBundle\Notification\RemindAttendanceNotification;
use Ferienpass\CoreBundle\Notifier\Notifier;
use Ferienpass\CoreBundle\Repository\AttendanceRepository;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Notifier\Recipient\Recipient;
use Symfony\Component\Uid\Uuid;

#[AsMessageHandler(bus: 'command.bus')]
class RemindAttendance
{
    public function __construct(private readonly Notifier $notifier, private readonly AttendanceRepository $attendances, private readonly PhoneFormatter $phone)
    {
    }

    public function __invoke(RemindAttendanceEvent $event, Uuid $uuid): void
    {
        /** @var Attendance $attendance */
        $attendance = $this->attendances->find($event->getAttendanceId());
        if (null === $attendance || '' === $email = (string) $attendance->getParticipant()?->getEmail()) {
            return;
        }

        $notification = $this->notifier->remindAttendance($attendance);
        if (!$notification instanceof RemindAttendanceNotification) {
            return;
        }

        $this->notifier->send($notification->belongsTo($uuid), new Recipient($email, (string) $this->phone->format($attendance->getParticipant()?->getMobile())));
    }
}
