<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\NotificationHandler;

use Ferienpass\AdminBundle\Controller\Page\AccountsController;
use Ferienpass\CoreBundle\Entity\Host;
use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Message\HostCreated as HostCreatedEvent;
use Ferienpass\CoreBundle\Notifier\Notifier;
use Ferienpass\CoreBundle\Repository\HostRepository;
use Ferienpass\CoreBundle\Repository\UserRepository;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Notifier\Recipient\Recipient;
use Symfony\Component\Routing\Generator\UrlGeneratorInterface;
use Symfony\Component\Uid\Uuid;

#[AsMessageHandler(bus: 'event.bus')]
class HostCreated
{
    public function __construct(private readonly Notifier $notifier, private readonly HostRepository $hosts, private readonly UserRepository $user, private readonly UrlGeneratorInterface $urlGenerator)
    {
    }

    public function __invoke(HostCreatedEvent $event, Uuid $uuid): void
    {
        /** @var User $user */
        $user = $this->user->find($event->getUserId());
        /** @var Host $host */
        $host = $this->hosts->find($event->getHostId());
        if (null === $user || null === $host) {
            return;
        }

        $notification = $this->notifier->hostCreated($host, $user);
        if (!$notification instanceof \Ferienpass\CoreBundle\Notification\HostCreatedNotification || '' === $email = (string) $notification->getEmailTo()) {
            return;
        }

        $this->notifier->send(
            $notification->belongsTo($uuid)->actionUrl($this->urlGenerator->generate('admin_accounts_index', ['role' => array_search('ROLE_HOST', AccountsController::ROLES, true)], UrlGeneratorInterface::ABSOLUTE_URL)),
            new Recipient($email)
        );
    }
}
