<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\NotificationHandler;

use Contao\CoreBundle\Filesystem\VirtualFilesystemInterface;
use Ferienpass\CoreBundle\Message\ExportFinished as ExportFinishedEvent;
use Ferienpass\CoreBundle\Notification\DownloadNotification;
use Ferienpass\CoreBundle\Notifier\Notifier;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Notifier\Recipient\Recipient;

#[AsMessageHandler(bus: 'event.bus')]
class ExportFinished
{
    public function __construct(private readonly Notifier $notifier, private readonly DownloadNotification $notification, private readonly VirtualFilesystemInterface $exportStorage)
    {
    }

    public function __invoke(ExportFinishedEvent $event): void
    {
        $file = $this->exportStorage->get($event->getFile());
        $url = $this->exportStorage->generatePublicUri($event->getFile());

        $notification = clone $this->notification;
        $this->notifier->send(
            $notification
                ->subject('Download')
                ->filename($file->getName())
                ->actionUrl((string) $url),
            new Recipient($event->getRecipient())
        );
    }
}
