<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\NotificationHandler;

use Ferienpass\CoreBundle\Entity\User;
use Ferienpass\CoreBundle\Message\AccountActivated as AccountActivatedEvent;
use Ferienpass\CoreBundle\Notifier\Notifier;
use Ferienpass\CoreBundle\Repository\UserRepository;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Notifier\Recipient\Recipient;
use Symfony\Component\Uid\Uuid;

#[AsMessageHandler(bus: 'event.bus')]
class AccountActivated
{
    public function __construct(private readonly Notifier $notifier, private readonly UserRepository $users)
    {
    }

    public function __invoke(AccountActivatedEvent $event, Uuid $uuid): void
    {
        /** @var User $user */
        $user = $this->users->find($event->getUserId());
        if (null === $user) {
            return;
        }

        $notification = $this->notifier->accountActivated($user);
        if (!$notification instanceof \Ferienpass\CoreBundle\Notification\AccountActivatedNotification || '' === $email = (string) $user->getEmail()) {
            return;
        }

        $this->notifier->send($notification->belongsTo($uuid), new Recipient($email));
    }
}
