<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Notification;

use Ferienpass\CoreBundle\Entity\Edition;

trait EditionEntityTrait
{
    private ?Edition $editionEntity = null;

    public function edition(Edition $edition): static
    {
        $this->editionEntity = $edition;

        return $this;
    }

    public function getEdition(): ?Edition
    {
        return $this->editionEntity;
    }
}
