<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Migration;

use Contao\CoreBundle\Migration\AbstractMigration;
use Contao\CoreBundle\Migration\MigrationResult;
use Doctrine\DBAL\Connection;

class PayableMigration extends AbstractMigration
{
    public function __construct(
        private readonly Connection $db,
    ) {
    }

    public function shouldRun(): bool
    {
        $schemaManager = $this->db->createSchemaManager();

        if (!$schemaManager->tablesExist(['Attendance'])) {
            return false;
        }

        $columns = $schemaManager->listTableColumns('Attendance');

        return !isset($columns['payable']);
    }

    public function run(): MigrationResult
    {
        $this->db->executeStatement('ALTER TABLE Attendance ADD payable TINYINT(1) DEFAULT 0 NOT NULL');
        $this->db->executeStatement("UPDATE Attendance SET payable = 1 WHERE status = 'confirmed'");

        return new MigrationResult(true, 'Migration successful');
    }
}
