<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Messenger;

use Symfony\Component\Messenger\Stamp\StampInterface;
use Symfony\Component\Uid\Uuid;

class UuidStamp implements StampInterface
{
    private readonly Uuid $uuid;

    public function __construct(Uuid|string|null $uuid = null)
    {
        $uuid ??= Uuid::v4();
        $this->uuid = \is_string($uuid) ? Uuid::fromString($uuid) : $uuid;
    }

    public function getUuid(): Uuid
    {
        return $this->uuid;
    }
}
