<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\MessageHandler;

use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Message\ReorderParticipantList;
use Ferienpass\CoreBundle\Message\UpdateParticipantPriorities;
use Ferienpass\CoreBundle\Message\WithdrawAttendance as WithdrawAttendanceCommand;
use Ferienpass\CoreBundle\Repository\AttendanceRepository;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Uid\Uuid;

#[AsMessageHandler(bus: 'command.bus')]
class WithdrawAttendance
{
    public function __construct(private readonly AttendanceRepository $attendances, private readonly MessageBusInterface $commandBus)
    {
    }

    public function __invoke(WithdrawAttendanceCommand $command, Uuid $uuid): void
    {
        $attendance = $this->attendances->find($command->getAttendanceId());
        if (!$attendance instanceof Attendance) {
            return;
        }

        if ($command->shallReorder()) {
            $this->commandBus->dispatch(new ReorderParticipantList($attendance->getOffer()->getId()));
        }

        $this->commandBus->dispatch(new UpdateParticipantPriorities($attendance->getParticipant()->getId(), $attendance->getOffer()->getEdition()->getId()));
    }
}
