<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\MessageHandler;

use Ferienpass\CoreBundle\Message\SyncOfferVariants as SyncOfferVariantsCommand;
use Ferienpass\CoreBundle\Repository\OfferRepositoryInterface;
use Symfony\Component\Messenger\Attribute\AsMessageHandler;
use Symfony\Component\PropertyAccess\Exception\NoSuchPropertyException;
use Symfony\Component\PropertyAccess\PropertyAccess;

#[AsMessageHandler(bus: 'command.bus')]
class SyncOfferVariants
{
    public function __construct(private readonly OfferRepositoryInterface $offers)
    {
    }

    public function __invoke(SyncOfferVariantsCommand $command): void
    {
        $origin = $this->offers->find($command->getOfferId());

        $propertyAccessor = PropertyAccess::createPropertyAccessor();

        foreach ($origin->getVariants() as $variant) {
            foreach ($this->offers->variantFields() as $field) {
                try {
                    $newValue = $propertyAccessor->getValue($origin, $field);
                } catch (NoSuchPropertyException) {
                    continue;
                }

                $propertyAccessor->setValue($variant, $field, $newValue);
            }
        }
    }
}
