<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Attendance;

class WithdrawAttendance implements LoggableMessageInterface
{
    public function __construct(private readonly int $attendanceId, private readonly bool $reorder, private readonly bool $notify)
    {
    }

    public function getAttendanceId(): int
    {
        return $this->attendanceId;
    }

    public function shallReorder(): bool
    {
        return $this->reorder;
    }

    public function shallNotify(): bool
    {
        return $this->notify;
    }

    public function getRelated(): array
    {
        return [
            Attendance::class => $this->attendanceId,
        ];
    }
}
