<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

class UpdateParticipantPriorities
{
    public function __construct(private readonly int $participantId, private readonly int $editionId)
    {
    }

    public function getParticipantId(): int
    {
        return $this->participantId;
    }

    public function getEditionId(): int
    {
        return $this->editionId;
    }
}
