<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Payment;
use Symfony\Component\Uid\Uuid;

class SendMailing implements LoggableMessageInterface, GroupedMessageInterface
{
    public function __construct(private readonly string $email, private readonly string $subject, private readonly string $content, private readonly array $context, private readonly array $attachments = [], private readonly ?Uuid $groupId = null, private readonly ?Payment $payment = null)
    {
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getSubject(): string
    {
        return $this->subject;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function getContext(): array
    {
        return $this->context;
    }

    public function getAttachments(): array
    {
        return $this->attachments;
    }

    public function getPayment(): ?Payment
    {
        return $this->payment;
    }

    public function getRelated(): array
    {
        return [];
    }

    public function groupedBy(): ?string
    {
        return (string) $this->groupId;
    }
}
