<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Payment;

class PaymentReceiptCreated implements LoggableMessageInterface
{
    public function __construct(private readonly string $paymentUuid)
    {
    }

    public function getPaymentUuid(): string
    {
        return $this->paymentUuid;
    }

    public function getRelated(): array
    {
        return [
            Payment::class => $this->paymentUuid,
        ];
    }
}
