<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Attendance;
use Symfony\Component\Uid\Uuid;

/**
 * This message is dispatched when an offer that originally was cancelled is being relaunched.
 */
class OfferRelaunched implements LoggableMessageInterface, GroupedMessageInterface
{
    public function __construct(private readonly int $attendanceId, private readonly Uuid $uuid, private readonly ?string $notifyText = null)
    {
    }

    public function getAttendanceId(): int
    {
        return $this->attendanceId;
    }

    public function getNotifyText(): ?string
    {
        return $this->notifyText;
    }

    public function getRelated(): array
    {
        return [
            Attendance::class => $this->attendanceId,
        ];
    }

    public function groupedBy(): ?string
    {
        return (string) $this->uuid;
    }
}
