<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Symfony\Component\Lock\Key;

class LotOffer implements LoggableMessageInterface
{
    public function __construct(private readonly int $offerId, private readonly Key $key, private readonly bool $useWaitlist = true)
    {
    }

    public function getOfferId(): int
    {
        return $this->offerId;
    }

    public function getKey(): Key
    {
        return $this->key;
    }

    public function shouldUseWaitlist(): bool
    {
        return $this->useWaitlist;
    }

    public function getRelated(): array
    {
        return [
            OfferInterface::class => $this->offerId,
        ];
    }
}
