<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Edition;

class LotEdition implements LoggableMessageInterface
{
    public function __construct(private readonly int $editionId, private readonly bool $useWaitlist = true, private readonly bool $ignoreMinParticipants = false)
    {
    }

    public function getEditionId(): int
    {
        return $this->editionId;
    }

    public function shouldUseWaitlist(): bool
    {
        return $this->useWaitlist;
    }

    public function shouldIgnoreMinParticipants(): bool
    {
        return $this->ignoreMinParticipants;
    }

    public function getRelated(): array
    {
        return [
            Edition::class => $this->editionId,
        ];
    }
}
