<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

class ExportFinished
{
    public function __construct(private readonly string $file, private readonly string $recipient)
    {
    }

    public function getFile(): string
    {
        return $this->file;
    }

    public function getRecipient(): string
    {
        return $this->recipient;
    }
}
