<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

class DispatchMailing implements LoggableMessageInterface
{
    public function __construct(private readonly ?int $invokingUserId, private readonly array $emails, private readonly string $subject, private readonly string $content, private readonly array $context, private readonly array $attachments = [], private readonly bool $withPaymentLink = false)
    {
    }

    public function getInvokingUserId(): ?int
    {
        return $this->invokingUserId;
    }

    public function getEmails(): array
    {
        return $this->emails;
    }

    public function getSubject(): string
    {
        return $this->subject;
    }

    public function getContent(): string
    {
        return $this->content;
    }

    public function getContext(): array
    {
        return $this->context;
    }

    public function getAttachments(): array
    {
        return $this->attachments;
    }

    public function isWithPaymentLink(): bool
    {
        return $this->withPaymentLink;
    }

    public function getRelated(): array
    {
        return [];
    }
}
