<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Attendance;
use Symfony\Component\Uid\Uuid;

class DecisionLetterDispatched implements LoggableMessageInterface, GroupedMessageInterface
{
    public function __construct(private readonly string $email, private readonly int $editionId, private readonly array $attendanceIds, private readonly Uuid $groupId)
    {
    }

    public function getEmail(): string
    {
        return $this->email;
    }

    public function getEditionId(): int
    {
        return $this->editionId;
    }

    public function getAttendanceIds(): array
    {
        return $this->attendanceIds;
    }

    public function groupedBy(): ?string
    {
        return (string) $this->groupId;
    }

    public function getRelated(): array
    {
        return [
            Attendance::class => $this->attendanceIds,
        ];
    }
}
