<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Attendance;

class CommitAttendances implements LoggableMessageInterface
{
    public function __construct(private readonly int $editionId, private readonly array $attendanceIds, private readonly bool $sendDecisions)
    {
    }

    public function getEditionId(): int
    {
        return $this->editionId;
    }

    public function getAttendanceIds(): array
    {
        return $this->attendanceIds;
    }

    public function shouldSendDecisions(): bool
    {
        return $this->sendDecisions;
    }

    public function getRelated(): array
    {
        return [
            Attendance::class => $this->attendanceIds,
        ];
    }
}
