<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Message;

use Ferienpass\CoreBundle\Entity\Attendance;

class AttendanceCreated implements LoggableMessageInterface
{
    public function __construct(private readonly int $attendance, private readonly bool $notify = true, private readonly ?string $host = null)
    {
    }

    public function getAttendance(): int
    {
        return $this->attendance;
    }

    public function shallNotify(): bool
    {
        return $this->notify;
    }

    public function getHost(): ?string
    {
        return $this->host;
    }

    public function getRelated(): array
    {
        return [
            Attendance::class => $this->attendance,
        ];
    }
}
