<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\EventListener\Workflow;

use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Message\AttendanceCreated;
use Ferienpass\CoreBundle\Message\AttendanceStatusChanged;
use Symfony\Component\HttpFoundation\RequestStack;
use Symfony\Component\Messenger\MessageBusInterface;
use Symfony\Component\Workflow\Attribute\AsAnnounceListener;
use Symfony\Component\Workflow\Event\AnnounceEvent;

#[AsAnnounceListener(workflow: 'attendance')]
class AttendanceStatusTransactionListener
{
    public function __construct(private readonly MessageBusInterface $eventBus, private readonly RequestStack $requestStack)
    {
    }

    public function __invoke(AnnounceEvent $event): void
    {
        $attendance = $event->getSubject();
        if (!$attendance instanceof Attendance) {
            throw new \RuntimeException('Unexpected event subject');
        }

        $context = $event->getContext();
        $shallNotify = $context['notify'] ?? true;

        if ($context['initial'] ?? false) {
            $host = $this->requestStack->getCurrentRequest()?->getHost();
            $this->eventBus->dispatch(new AttendanceCreated($attendance->getId(), $shallNotify, $host));

            return;
        }

        if (null === $attendance->getStatus()) {
            return;
        }

        $transition = $event->getTransition();
        $this->eventBus->dispatch(new AttendanceStatusChanged($attendance->getId(), $transition->getFroms()[0] ?? null, $attendance->getStatus(), $shallNotify));
    }
}
