<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\EventListener\Workflow;

use Ferienpass\CoreBundle\Entity\Attendance;
use Symfony\Component\Workflow\Attribute\AsEnteredListener;
use Symfony\Component\Workflow\Event\EnteredEvent;

#[AsEnteredListener(workflow: 'attendance', place: Attendance::STATUS_CONFIRMED)]
class AttendanceConfirmTransactionListener
{
    public function __invoke(EnteredEvent $event): void
    {
        $attendance = $event->getSubject();
        if (!$attendance instanceof Attendance) {
            throw new \RuntimeException('Unexpected event subject');
        }

        $context = $event->getContext();
        $commit = $context['commit'] ?? true;

        if ($commit && $attendance->getOffer()->getFee() && $attendance->getOffer()->isOnlinePayable()) {
            $attendance->setPayable(true);
        }
    }
}
