<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\EventListener\Mailer;

use Ferienpass\CoreBundle\Notifier\Mime\NotificationEmail;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\Attribute\AsEventListener;
use Symfony\Component\Mailer\Event\SentMessageEvent;

#[AsEventListener]
class SentMessageListener
{
    public function __construct(private readonly LoggerInterface $notificationsLogger)
    {
    }

    public function __invoke(SentMessageEvent $event): void
    {
        $message = $event->getMessage()->getOriginalMessage();
        if (!$message instanceof NotificationEmail) {
            return;
        }

        $this->notificationsLogger->info('Sent an email', [
            'email' => $message,
            'messageId' => $event->getMessage()->getMessageId(),
        ]);
    }
}
