<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\EventListener\Doctrine\Offer;

use Doctrine\ORM\Events;
use Ferienpass\CoreBundle\Attribute\AsOfferEntityListener;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Message\SyncOfferVariants;
use Symfony\Component\Messenger\MessageBusInterface;

#[AsOfferEntityListener(event: Events::postUpdate)]
class VariantListener
{
    public function __construct(private readonly MessageBusInterface $commandBus)
    {
    }

    public function postUpdate(OfferInterface $offer): void
    {
        if (!$offer->hasVariants()) {
            return;
        }

        $this->commandBus->dispatch(new SyncOfferVariants($offer->getId()));
    }
}
