<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;
use Ferienpass\CoreBundle\Repository\WorkflowSurveyRepository;

#[ORM\Entity(repositoryClass: WorkflowSurveyRepository::class)]
class WorkflowSurvey
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer', options: ['unsigned' => true])]
    private ?int $id = null;

    #[ORM\Column(type: 'json', nullable: true)]
    private ?array $data = null;

    public function __construct(
        #[ORM\ManyToOne(targetEntity: OfferInterface::class, inversedBy: 'attendances')]
        #[ORM\JoinColumn(name: 'offer_id', referencedColumnName: 'id')]
        private OfferInterface $offer,
        #[ORM\Column(type: 'string', length: 64)]
        private string $survey
    ) {
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getSurvey(): string
    {
        return $this->survey;
    }

    public function getData(): ?array
    {
        return $this->data;
    }

    public function setData(?array $data): void
    {
        $this->data = $data;
    }
}
