<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

#[ORM\Entity]
class PmPaymentTransactionStatus
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer', options: ['unsigned' => true])]
    private ?int $id = null;

    public function __construct(
        #[ORM\Column(type: 'string', length: 64, unique: true)]
        private readonly string $txid,
        #[ORM\Column(type: 'integer', length: 5)]
        private int $status,
        #[ORM\Column(type: 'string', nullable: true)]
        private ?string $description,
        #[ORM\Column(type: 'datetime_immutable', nullable: true)]
        private ?\DateTimeInterface $createdAt,
        #[ORM\Column(type: 'datetime_immutable', nullable: true)]
        private ?\DateTimeInterface $modifiedAt,
        #[ORM\Column(type: 'json')]
        private array $payload
    ) {
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function getCreatedAt(): ?\DateTimeInterface
    {
        return $this->createdAt;
    }

    public function getModifiedAt(): ?\DateTimeInterface
    {
        return $this->modifiedAt;
    }

    public function getPayload(): array
    {
        return $this->payload;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function getTxid(): string
    {
        return $this->txid;
    }

    public function setStatus(int $status): void
    {
        $this->status = $status;
    }

    public function setDescription(?string $description): void
    {
        $this->description = $description;
    }

    public function setCreatedAt(?\DateTimeInterface $createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    public function setModifiedAt(?\DateTimeInterface $modifiedAt): void
    {
        $this->modifiedAt = $modifiedAt;
    }

    public function setPayload(array $payload): void
    {
        $this->payload = $payload;
    }
}
