<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity\Participant;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\Edition;
use Ferienpass\CoreBundle\Entity\FriendCode;
use Ferienpass\CoreBundle\Entity\User;
use Symfony\Component\Uid\Uuid;

interface ParticipantInterface
{
    public function getId(): ?int;

    public function getUuid(): Uuid;

    public function getName(): string;

    public function getFirstname(): ?string;

    public function getLastname(): ?string;

    public function getAge(?\DateTimeInterface $atDate = null): ?int;

    public function getUser(): ?User;

    /** @var ArrayCollection<int, Attendance> */
    public function getAttendances(): Collection;

    /** @var Collection<int, Attendance> */
    public function getAttendancesNotWithdrawn(?Edition $edition = null, $includedCancelled = true): Collection;

    /** @var Collection<int, Attendance> */
    public function getAttendancesNotHidden(?Edition $edition = null, $includedCancelled = true): Collection;

    /** @var Collection<int, FriendCode> */
    public function getFriendCodes(): Collection;

    public function addFriendCode(?FriendCode $code): void;

    public function getPostalCode(): ?string;
}
