<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;

#[ORM\Entity]
class OfferMedia
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer', options: ['unsigned' => true])]
    private int $id;

    #[ORM\ManyToOne(targetEntity: OfferInterface::class, inversedBy: 'media')]
    #[ORM\JoinColumn(name: 'offer_id', referencedColumnName: 'id', nullable: false, onDelete: 'CASCADE')]
    private OfferInterface $offer;

    #[ORM\ManyToOne(targetEntity: DbafsMedia::class, inversedBy: 'offers')]
    #[ORM\JoinColumn(name: 'media_id', referencedColumnName: 'uuid', nullable: false, onDelete: 'CASCADE')]
    private DbafsMedia $media;

    public function __construct(?OfferInterface $offer = null, ?DbafsMedia $media = null)
    {
        if ($offer instanceof OfferInterface) {
            $this->offer = $offer;
        }

        if ($media instanceof DbafsMedia) {
            $this->media = $media;
        }
    }

    public function setOffer(OfferInterface $offer): void
    {
        $this->offer = $offer;
    }

    public function setMedia(DbafsMedia $media): void
    {
        $this->media = $media;
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getMedia(): DbafsMedia
    {
        return $this->media;
    }
}
