<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ferienpass\CoreBundle\Entity\Offer\OfferInterface;

#[ORM\Entity]
class OfferAttachment
{
    #[ORM\Id]
    #[ORM\GeneratedValue]
    #[ORM\Column(type: 'integer', options: ['unsigned' => true])]
    private int $id;

    #[ORM\ManyToOne(targetEntity: OfferInterface::class, inversedBy: 'attachments')]
    #[ORM\JoinColumn(name: 'offer_id', referencedColumnName: 'id', onDelete: 'CASCADE')]
    private OfferInterface $offer;

    #[ORM\ManyToOne(targetEntity: DbafsAttachment::class, inversedBy: 'offers')]
    #[ORM\JoinColumn(name: 'attachment_id', referencedColumnName: 'uuid', onDelete: 'CASCADE')]
    private DbafsAttachment $attachment;

    #[ORM\Column(type: 'boolean', nullable: false)]
    private bool $agreementLetter = false;

    public function __construct(?OfferInterface $offer = null, ?DbafsAttachment $attachment = null)
    {
        if ($offer instanceof OfferInterface) {
            $this->offer = $offer;
        }

        if ($attachment instanceof DbafsAttachment) {
            $this->attachment = $attachment;
        }
    }

    public function setOffer(OfferInterface $offer): void
    {
        $this->offer = $offer;
    }

    public function setAttachment(DbafsAttachment $attachment): void
    {
        $this->attachment = $attachment;
    }

    public function getOffer(): OfferInterface
    {
        return $this->offer;
    }

    public function getAttachment(): DbafsAttachment
    {
        return $this->attachment;
    }

    public function isAgreementLetter(): bool
    {
        return $this->agreementLetter;
    }

    public function setAgreementLetter(bool $agreementLetter): void
    {
        $this->agreementLetter = $agreementLetter;
    }
}
