<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity\Offer;

use Doctrine\Common\Collections\Collection;
use Ferienpass\CoreBundle\Entity\Attendance;
use Ferienpass\CoreBundle\Entity\Host;
use Ferienpass\CoreBundle\Entity\OfferAttachment;
use Ferienpass\CoreBundle\Entity\OfferDate;
use Ferienpass\CoreBundle\Entity\Participant\ParticipantInterface;
use Symfony\Component\String\Slugger\SluggerInterface;
use Symfony\Component\Uid\Uuid;
use Symfony\Contracts\EventDispatcher\EventDispatcherInterface;

interface OfferInterface
{
    final public const STATE_DRAFT = 'draft';
    final public const STATE_FINALIZED = 'finalized';
    final public const STATE_REVIEWED = 'reviewed';
    final public const STATE_PUBLISHED = 'published';
    final public const STATE_CANCELLED = 'cancelled';
    final public const STATE_COMPLETED = 'completed';
    final public const TRANSITION_COMPLETE = 'complete';
    final public const TRANSITION_FINALIZE = 'finalize';
    final public const TRANSITION_APPROVE = 'approve';
    final public const TRANSITION_UNAPPROVE = 'unapprove';
    final public const TRANSITION_TO_DRAFT = 'to_draft';
    final public const TRANSITION_PUBLISH = 'publish';
    final public const TRANSITION_UNPUBLISH = 'unpublish';
    final public const TRANSITION_CANCEL = 'cancel';
    final public const TRANSITION_RELAUNCH = 'relaunch';

    public function getId(): ?int;

    public function getUuid(): Uuid;

    public function getName(): string;

    public function getAlias(): ?string;

    public function isVariantBase(): bool;

    public function hasVariants(): bool;

    public function isVariant(): bool;

    public function isVariantOf(self $offer): bool;

    public function getVariants(): Collection;

    public function getVariantBase(): ?self;

    /**
     * @return Collection<int, Host>
     */
    public function getHosts(): Collection;

    // TODO refactor to own interface, make non-nullable
    public function getFee(): ?int;

    public function isOnlinePayable(): bool;

    /**
     * @return Collection<int, OfferDate>
     */
    public function getDates(): Collection;

    public function getApplicationDeadline(): ?\DateTimeInterface;

    public function getDateBegin(): ?\DateTimeInterface;

    public function getDateEnd(): ?\DateTimeInterface;

    public function isPublished(): bool;

    public function isFinalized(): bool;

    public function isReviewed(): bool;

    public function getMinParticipants(): ?int;

    public function getMaxParticipants(): ?int;

    public function isCancelled(): bool;

    public function isCompleted(): bool;

    public function requiresApplication(): bool;

    public function isOnlineApplication(): bool;

    /**
     * @return Collection<OfferAttachment>
     */
    public function getAttachments(): Collection;

    public function getAttendances(): Collection;

    public function getAttendancesNotHidden(): Collection;

    public function getAttendancesConfirmed(): Collection;

    /**
     * @return Collection<Attendance>
     */
    public function getAttendancesWaiting(): Collection;

    public function getAttendancesWaitlisted(): Collection;

    public function getAttendancesConfirmedOrWaiting(): Collection;

    public function getAttendancesConfirmedOrWaitlisted(): Collection;

    public function addAttendance(Attendance $attendance): void;

    public function generateAlias(SluggerInterface $slugger): void;

    public function getFeePayable(ParticipantInterface $participant, ?EventDispatcherInterface $dispatcher = null): int;

    public function getFriendCodes(): Collection;

    public function setStateManually(string $state): void;

    public function resetStatus(): void;

    public function isDraft(): bool;
}
