<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Serializer\Annotation\Groups;
use Symfony\Component\Uid\Uuid;

#[ORM\Entity]
class DbafsAttachment
{
    #[ORM\Column(type: 'integer', unique: true, nullable: true, options: ['unsigned' => true], columnDefinition: 'INT AUTO_INCREMENT UNIQUE')]
    private ?int $id = null;

    #[ORM\Id]
    #[ORM\Column(type: UuidType::NAME)]
    #[ORM\GeneratedValue(strategy: 'CUSTOM')]
    #[ORM\CustomIdGenerator(class: 'doctrine.uuid_generator')]
    private ?Uuid $uuid = null;

    #[ORM\Column(type: 'datetime_immutable', options: ['default' => 'CURRENT_TIMESTAMP'])]
    #[Groups('notification')]
    private \DateTimeInterface $createdAt;

    #[ORM\Column(type: UuidType::NAME, nullable: true)]
    private ?Uuid $pid = null;

    #[ORM\Column(type: 'string')]
    private ?string $path = null;
    #[ORM\Column(type: 'string', length: 16)]
    private ?string $type = null;
    #[ORM\Column(type: 'string', length: 64)]
    private ?string $hash = null;

    #[ORM\Column(type: 'integer', length: 13, nullable: true)]
    private ?int $lastModified = null;

    #[ORM\ManyToOne(targetEntity: User::class)]
    #[ORM\JoinColumn(name: 'uploaded_by', referencedColumnName: 'id', onDelete: 'CASCADE')]
    private ?User $uploadedBy = null;

    #[ORM\OneToMany(targetEntity: OfferAttachment::class, mappedBy: 'attachment')]
    private Collection $offers;
    #[ORM\OneToMany(targetEntity: Notification::class, mappedBy: 'emailAttachment')]
    private Collection $notifications;

    public function __construct()
    {
        $this->offers = new ArrayCollection();
        $this->notifications = new ArrayCollection();
        $this->createdAt = new \DateTimeImmutable();
    }

    public function getPath(): ?string
    {
        return $this->path;
    }

    public function getUuid(): ?Uuid
    {
        return $this->uuid;
    }

    public function getCreatedAt(): \DateTimeInterface
    {
        return $this->createdAt;
    }

    public function setCreatedAt(\DateTimeInterface $createdAt): void
    {
        $this->createdAt = $createdAt;
    }

    public function getOffers(): Collection
    {
        return $this->offers;
    }

    public function getNotifications(): Collection
    {
        return $this->notifications;
    }

    public function getUploadedBy(): ?User
    {
        return $this->uploadedBy;
    }

    public function setUploadedBy(?User $uploadedBy): void
    {
        $this->uploadedBy = $uploadedBy;
    }

    public function getLastModified(): \DateTimeInterface
    {
        return new \DateTimeImmutable('@'.$this->lastModified);
    }

    public function setLastModified(?int $lastModified): void
    {
        $this->lastModified = $lastModified;
    }
}
