<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Symfony\Bridge\Doctrine\IdGenerator\UuidGenerator;
use Symfony\Bridge\Doctrine\Types\UuidType;
use Symfony\Component\Uid\Uuid;

#[ORM\Entity]
#[ORM\Immutable]
class ConsentText
{
    #[ORM\Id]
    #[ORM\GeneratedValue(strategy: 'CUSTOM')]
    #[ORM\Column(type: UuidType::NAME, unique: true)]
    #[ORM\CustomIdGenerator(class: UuidGenerator::class)]
    private Uuid $id;

    #[ORM\Column(type: 'string', length: 64)]
    private string $hash;

    #[ORM\Column(type: 'text')]
    private string $text;

    public function __construct(string $text)
    {
        $this->text = $text;
        $this->hash = hash('sha256', $text);
    }

    public function getId(): Uuid
    {
        return $this->id;
    }

    public function getHash(): string
    {
        return $this->hash;
    }

    public function getText(): string
    {
        return $this->text;
    }
}
