<?php

declare(strict_types=1);

/*
 * This file is part of the Ferienpass package.
 *
 * (c) Richard Henkenjohann <richard@ferienpass.online>
 *
 * For more information visit the project website <https://ferienpass.online>
 * or the documentation under <https://docs.ferienpass.online>.
 */

namespace Ferienpass\CoreBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use Ferienpass\CoreBundle\Repository\AgreementLetterSignaturesRepository;

#[ORM\Entity(repositoryClass: AgreementLetterSignaturesRepository::class)]
class AgreementLetterSignature extends Consent
{
    public function __construct(
        User $user,
        #[ORM\ManyToOne(targetEntity: Edition::class)]
        private Edition $edition,
        string $hash
    ) {
        parent::__construct($user, $hash);
    }

    public static function fromEdition(Edition $edition, User $user): self
    {
        return new self($user, $edition, hash('sha256', (string) $edition->getAgreementLetterText()));
    }

    public function getEdition(): Edition
    {
        return $this->edition;
    }
}
